@extends('layouts.dasht')
@section('title', $title)
@section('content')
    <!-- Page title -->
    <div class="udex-main" id="main">
    <x-danger-alert />
    <x-success-alert />
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <div class="mb-5 row">
                        <div class="p-2 text-center p-md-4 col-12">
                            <div class="table-responsive">
                                <div class="bg-white rounded mb-2 border">
                                    <h4 class="mb-0 p-3">Trading History</h4>
                                    <div class="table-responsive">
                                        <table class="table table-hover table-striped">
                                            
                                            <tr>
                                                <th style="min-width: 150px">Details</th><th style="min-width: 100px">Amount</th><th style="min-width: 150px">Status</th>
                                            </tr>
                                            @foreach($t_history as $history)
                                            @if($history->type=='LOSE')
                                            <tr>
                                                    <td>
                                                        <strong><span class="text-danger"><i class="fas fa-arrow-down mr-1"></i>{{ $history->plan }}</span></strong><br />
                                                        <date class="small text-black-50">{{ $history->created_at->toDayDateTimeString() }}</date>
                                                    </td>
                                                    <td class="text-danger">{{ Auth::user()->currency }} {{ $history->amount }}</td>
                                                    <td><span class="badge badge-pill badge-danger">Expired</span> <span class="small">LOSE - {{ $history->leverage }}%</span>
                                                    <div class="small text-black-50">{{ $history->created_at->toDayDateTimeString() }}</div></td>
                                                </tr>
                                                @elseif($history->type=='WIN')
                                                <tr>
                                                    <td>
                                                        <strong><span class="text-success"><i class="fas fa-arrow-up mr-1"></i>{{ $history->plan }}</span></strong><br />
                                                        <date class="small text-black-50">{{ $history->created_at->toDayDateTimeString() }}</date>
                                                    </td>
                                                    <td class="text-success">{{ Auth::user()->currency }} {{ $history->amount }}</td>
                                                    <td><span class="badge badge-pill badge-danger">Expired</span> <span class="small badge badge-pill badge-success">WIN +{{ $history->leverage }}%</span>
                                                    <div class="small text-black-50">{{ $history->created_at->toDayDateTimeString() }}</div></td>
                                                </tr>
                    
                                                @else
                                                @if($history->type=='Buy')
                                                <tr>
                                                    <td>
                                                        <strong><span class="text-success"><i class="fas fa-arrow-up mr-1"></i>{{ $history->plan }}</span></strong><br />
                                                        <date class="small text-black-50">{{ $history->created_at->toDayDateTimeString() }}</date>
                                                    </td>
                                                    <td>{{ Auth::user()->currency }} {{ $history->amount }}</td>
                                                    <td><span class="badge badge-pill badge-success"> {{ $history->type }} </span> <span class="small">Leverage: 1:{{ $history->leverage }}</span>
                                                    <div class="small text-black-50">{{ $history->created_at->toDayDateTimeString() }}</div></td>
                                                </tr>
                                                @else
                                                <tr>
                                                    <td>
                                                        <strong><span class="text-danger"><i class="fas fa-arrow-down mr-1"></i>{{ $history->plan }}</span></strong><br />
                                                        <date class="small text-black-50">{{ $history->created_at->toDayDateTimeString() }}</date>
                                                    </td>
                                                    <td>{{ Auth::user()->currency }} {{ $history->amount }}</td>
                                                    <td><span class="badge badge-pill badge-danger"> {{ $history->type }} </span> <span class="small">Leverage: 1:{{ $history->leverage }}</span>
                                                    <div class="small text-black-50">{{ $history->created_at->toDayDateTimeString() }}</div></td>
                                                </tr>
                                                @endif
                                            @endif
                                            @endforeach
                                            </table>
                                    </div>
                                </div>
                               
                            </div>
                            {{ $t_history->links() }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
</div>
@endsection
