
@extends('layouts.dasht')
@section('title', $title)
@section('content')
<div class="udex-main" id="main" style="position: relative;">
	<x-danger-alert />
    <x-success-alert />
	<div class="container">
	<script src="{{ asset('themes/custom/js/validation.js')}}"></script>
	<h3>{{ Auth::user()->name }},<br />{{ \Carbon\Carbon::now()->toDayDateTimeString() }}</h3>
    <ul class="breadcrumb shadow-none p-0" style="background-color: transparent">
		<li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
		<li class="breadcrumb-item active">Dashboard</li>
	</ul>	
<form method="POST" enctype="multipart/form-data" action="{{ route('savedeposit') }}">
@csrf

	<div class="card">
		<div class="card-header">
			<h4 class="m-0">Add Fund({{ $payment_mode->name }})</h4>
		</div>
		<div class="card-body">
			<div class="form-group">
				<div class="input-group">
					<div class="input-group-prepend">
					<select name="method" class="custom-select input-group-text" style="width: 100px">
						<option selected>{{ Auth::user()->currency }}</option>
						<option>{{ $payment_mode->name }}</option>
					</select>
					</div>
					<!-- <input type="number" step="0.00000000001" name="invest_amount" max="20000" required placeholder="Enter Amount" required class="form-control" id="amount"> -->
				</div>
			</div>
			<div class="amountDisplay">Make Payment of {{ $amount }}{{ Auth::user()->currency }} to the address below and click "SEND PROOF OF DEPOSIT"</div><div class="row">
				<div class="col-md-3 pt-3">
					<img src="https://chart.googleapis.com/chart?chs=150x150&amp;cht=qr&amp;chl={{ $payment_mode->name }}:{{ $payment_mode->wallet_address }}">
				</div>
				<div class="col-md-9 py-3">
					<div class="input-group mb-3">
						<input type="text" class="form-control" value="{{ $payment_mode->wallet_address }}" required>
						<div class="input-group-append">
							<button type="button" onclick="copyFunction('{{ $payment_mode->wallet_address }}')" class="btn btn-light text-dark">Copy</button>
						</div>
					</div>
					<div class="custom-file">
						<input type="file" name="proof" class="custom-file-input" id="customFile" required>
						<label class="custom-file-label" for="customFile">Choose file</label>
					</div>
					<input type="hidden" name="amount" value="{{ $amount }}">
              <input type="hidden" name="paymethd_method" value="{{ $payment_mode->name }}">
			  @if($asset)
			  <input type="hidden" name="asset" value="{{ $asset }}">
			  @endif
				</div>
			</div></div>
		<div class="card-footer">
			<button class="btn btn-primary"><i class="fas fa-paper-plane mr-2"></i> SEND PROOF OF DEPOSIT</button>
		</div>
	</div>
	@endsection