@extends('layouts.dasht')
@section('title', $title)
@section('content')
    <!-- Page title -->
    <div class="udex-main" id="main">
    <div>
        <div class="row justify-content-between align-items-center">
            <div class="mb-3 col-md-6 mb-md-0">
            <h3 class="h4 m-0">
        Account Current Signal : {{ Auth::user()->signals }}
            </h3>
    <p class="m-0">All Signals.</p>
    <br>
            </div>
        </div>
    </div>
    <x-danger-alert />
    <x-success-alert />
     <x-alert />
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Signals</h5>
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead class="bg-primary text-white">
                                
                              
                                <th>
                                    Asset
                                </th>
                                <th>
                                   Order type
                                </th>
                                <th>
                                   Trade Amount
                                </th>
                                <th>
                                   Leverage
                                </th>
                              
                                <th>
                                    Status
                                </th>
                                <th>
                                    Date Added
                                </th>
                                <th>
                                   Signal Plan
                                </th>
                               
                            </thead>
                            <tbody>
                                @forelse ($signals as $signal)
                                    <tr>
                                        <td>{{ $signal->asset }}</td>
                                        <td>
                                            @if ($signal->order_type == 'Buy')
                                               <i class="fa fa-arrow-up text-success"></i> <span class='badge badge-success'>{{ $signal->order_type }}</span>
                                            @else
                                                <i class="fa fa-arrow-down text-danger"></i><span class='badge badge-danger'> {{ $signal->order_type }}</span>
                                            @endif
                                           
                                        </td>
                                        <td>{{ Auth::user()->currency }}{{ $signal->amount }}</td>

                                        <td>1:{{ $signal->leverage }}</td>
                                     
                                        <td>
                                            @if ($signal->status == 'ongoing')
                                               <span class='badge badge-warning'>{{ $signal->status}}</span>
                                            @else
                                              </i><span class='badge badge-danger'> {{ $signal->status }}</span>
                                            @endif
                                           
                                        </td>
                                        <td>{{ \Carbon\Carbon::parse($signal->created_at)->addHour()->toDayDateTimeString() }}
                                        </td>

                                        <td>
                                            {{ auth::user()->signals }}
                                        </td>
                                       
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="10" class="text-center">
                                            No Data Available
                                        </td>
                                    </tr>
                                @endforelse

                            </tbody>
                        </table>
                    </div>
                   
                </div>
            </div>
        </div>
    </div>
</div>
</div>
    </div>
</div>
@endsection
