@extends('layouts.dasht')
@section('title', $title)
@section('content')
    <!-- Title -->
    

<div class="udex-main" id="main">
    
    <x-danger-alert />
    <x-success-alert />
     <x-notify-alert />
   
        
<script src="{{ asset('themes/custom/js/validation.js') }}"></script>

        <div class="row">
            
        <div class="col-md-4 py-1">
            <div class="stats p-2 px-3 shadow-sm rounded seagreen">
                <h3> {{ Auth::user()->currency }}{{ number_format(Auth::user()->account_bal, 2, '.', ',') }}</h3>
                <span class="font-weight-bold">Deposits</span>
                <div class="stats-icon">
                    <i class="fas fa-dollar-sign"></i>
                </div>
            </div>
        </div>
        <div class="col-md-4 py-1">
            <div class="stats p-2 px-3 shadow-sm rounded bg-success">
                <h3>{{ Auth::user()->currency }}{{ number_format(Auth::user()->roi, 2, '.', ',') }}</h3>
               <span class="font-weight-bold">PROFIT</span>
                @if(auth::user()->signals !=Null)
                <h6>Current signal: <span class='badge badge-info'>{{ Auth::user()->signals }}</span></h6>
                @endif
                <div class="stats-icon">
                    <i class="fas fa-dollar-sign"></i>
                </div>
            </div>
        </div>
        <div class="col-md-4 py-1">
            <div class="stats p-2 px-3 shadow-sm rounded bg-danger">
                <h3> {{ Auth::user()->currency }}{{ number_format($total_withdrawal, 2, '.', ',') }}</h3>
                <span class="font-weight-bold">TOTAL WITHDRAWAL</span>
                <div class="stats-icon">
                    <i class="fas fa-money-bill"></i>
                </div>
            </div>
        </div>
        <div class="col-12 col-lg-8 py-2">
            <!-- TradingView Widget BEGIN -->
            <div class="tradingview-widget-container bg-white rounded">
                <img src="{{ asset('storage/app/public/'.$settings->favicon)}}">
                <div id="tradingview_d8291" style="height: 400px !important"></div>
                <script type="text/javascript" src="https://s3.tradingview.com/tv.js"></script>
                <script type="text/javascript">
                new TradingView.widget(
                {
                "autosize": true,
                "symbol": "FX_IDC:EURUSD",
                "interval": "1",
                "timezone": "Etc/UTC",
                "theme": "light",
                "style": "3",
                "locale": "en",
                "toolbar_bg": "#f1f3f6",
                "enable_publishing": false,
                "hide_top_toolbar": true,
                
                "save_image": false,
                "container_id": "tradingview_d8291"
                }
                );
                </script>
            </div>
            <!-- TradingView Widget END -->

        </div>
        <div class="col-12 col-lg-4 py-2">
            <form method="POST" action="{{route('joinplan')}}" class="bg-white p-3 p-md-4 rounded border h-100" id="createTrade">
                <h4 class="mb-3">Assets</h4>
                <div id="notifiAlert"></div>
                <div class="form-group">
                    <select class="custom-select" name="asset" id="select_assetss" required>
                        <optgroup label="Currency">
                            <option selected>EURUSD</option>
                            <option>EURJPY</option>
                            <option>USDJPY</option>
                            <option>USDCAD</option>
                            <option>AUDUSD</option>
                            <option>AUDJPY</option>
                            <option>NZDUSD</option>
                            <option>GBPUSD</option>
                            <option>GBPJPY</option>
                            <option>USDCHF</option>
                        </optgroup>
                        <optgroup label="Crypto-Currency">
                            <option>BTCUSD</option>
                            <option>ETHUSD</option>
                            <option>BCHUSD</option>
                            <option>XRPUSD</option>
                            <option>LTCUSD</option>
                            <option>ETHBTC</option>
                        </optgroup>
                        <optgroup label="Stocks">
                            <option>CITI</option>
                            <option>SNAP</option>
                            <option>EA</option>
                            <option>MSFT</option>
                            <option>CSCO</option>
                            <option>GOOG</option>
                            <option>FB</option>
                            <option>SBUX</option>
                            <option>INTC</option>
                        </optgroup>
                        <optgroup label="Indices">
                            <option>SPX500USD</option>
                            <option>MXX</option>
                            <option>XAX</option>
                            <option>INDEX:STI</option>
                        </optgroup>
                        <optgroup label="Commodities">
                            <option>GOLD</option>
                            <option>RB1!</option>
                            <option>USOIL</option>
                            <option>SILVER</option>
                        </optgroup>
                    </select>
                </div>
                <!--
                <div class="form-group">
                    <input type="limit" name="limit" placeholder="Order Limit" class="form-control" id="limit">
                </div>
                -->
                <div class="form-group">
                    <div class="input-group">
                        <div class="input-group-prepend">
                            <span class="input-group-text">{{ $settings->s_currency }}</span>
                        </div>
                        <input type="number" name="amount" placeholder="Invest Amount(0.00)" id="IAmount" min="50" max="500000" class="form-control" id="amount" required>
                    </div>
                </div>
                <div class="form-group">
                    <select class="custom-select" name="leverage" id="leverage" required>
                        <option selected disable value="">Leverage</option><option value="10">1:10</option><option value="20">1:20</option><option value="30">1:30</option><option value="40">1:40</option><option value="50">1:50</option><option value="60">1:60</option><option value="70">1:70</option><option value="80">1:80</option><option value="90">1:90</option><option value="100">1:100</option>
                    </select>
                </div>
                <div class="form-group">
                    <select class="custom-select" name="expire" id="expire" required>
                        <option selected disable value="">Expiration</option>
                        <option value="1 Minutes">1 Minute</option>
                        <option value="5 Minutes">5 Minutes</option>
                        <option value="15 Minutes">15 Minutes</option>
                        <option value="30 Minutes">30 Minutes</option>
                        <option value="60 Minutes">1 Hour</option>
                        <option value="4 Hours">4 Hours</option>
                        <option value="1 Days">1 Day</option>
                        <option value="2 Days">2 Days</option>
                        <option value="7 Days">7 Days</option>
                    </select>
                </div>
                 <input type="hidden" name="_token" value="{{ csrf_token() }}">
                <div class="row">
                    <div class="col-6">
                        <label for="call" class="btn btn-success btn-block place_order">BUY</label>
                        <input type="submit" name="order_type" id="call" value="Buy" class="d-none" />
                    </div>
                    <div class="col-6">
                        <label for="put" class="btn btn-danger btn-block place_order">SELL</label>
                        <input type="submit" name="order_type" id="put" value="Sell" class="d-none" />
                    </div>
                </div>
            </form>
        </div>
        
        <div class="col-md-6 py-2">
            <div class="bg-white rounded mb-2 border">
                <h4 class="mb-0 p-3">Latest Trades</h4>
                <div class="table-responsive">
                    <table class="table table-hover table-striped">
                        
                        <tr>
                            <th style="min-width: 150px">Details</th><th style="min-width: 100px">Amount</th><th style="min-width: 150px">Status</th>
                        </tr>
                        @foreach($t_history as $history)
                        @if($history->type=='LOSE')
                        <tr>
                                <td>
                                    <strong><span class="text-danger"><i class="fas fa-arrow-down mr-1"></i>{{ $history->plan }}</span></strong><br />
                                    <date class="small text-black-50">{{ $history->created_at->toDayDateTimeString() }}</date>
                                </td>
                                <td class="text-danger">{{ Auth::user()->currency }} {{ $history->amount }}</td>
                                <td><span class="badge badge-pill badge-danger">Expired</span> <span class="small badge badge-pill badge-danger">LOSE - {{ $history->leverage }}%</span>
                                <div class="small text-black-50">{{ $history->created_at->toDayDateTimeString() }}</div></td>
                            </tr>
                            @elseif($history->type=='WIN')
                            <tr>
                                <td>
                                    <strong><span class="text-success"><i class="fas fa-arrow-up mr-1"></i>{{ $history->plan }}</span></strong><br />
                                    <date class="small text-black-50">{{ $history->created_at->toDayDateTimeString() }}</date>
                                </td>
                                <td class="text-success">{{ Auth::user()->currency }} {{ $history->amount }}</td>
                                <td><span class="badge badge-pill badge-danger">Expired</span> <span class="small badge badge-pill badge-success">WIN +{{ $history->leverage }}%</span>
                                <div class="small text-black-50">{{ $history->created_at->toDayDateTimeString() }}</div></td>
                            </tr>

                            @else
                            @if($history->type=='Buy')
                            <tr>
                                <td>
                                    <strong><span class="text-success"><i class="fas fa-arrow-up mr-1"></i>{{ $history->plan }}</span></strong><br />
                                    <date class="small text-black-50">{{ $history->created_at->toDayDateTimeString() }}</date>
                                </td>
                                <td>{{ Auth::user()->currency }} {{ $history->amount }}</td>
                                <td><span class="badge badge-pill badge-success"> {{ $history->type }} </span> <span class="small">Leverage:1:{{ $history->leverage }}</span>
                                <div class="small text-black-50">{{ $history->created_at->toDayDateTimeString() }}</div></td>
                            </tr>
                            @else
                            <tr>
                                <td>
                                    <strong><span class="text-danger"><i class="fas fa-arrow-down mr-1"></i>{{ $history->plan }}</span></strong><br />
                                    <date class="small text-black-50">{{ $history->created_at->toDayDateTimeString() }}</date>
                                </td>
                                <td>{{ Auth::user()->currency }} {{ $history->amount }}</td>
                                <td><span class="badge badge-pill badge-danger"> {{ $history->type }} </span> <span class="small">Leverage:1:{{ $history->leverage }}</span>
                                <div class="small text-black-50">{{ $history->created_at->toDayDateTimeString() }}</div></td>
                            </tr>
                            @endif
                        @endif
                        @endforeach
                        </table>
                </div>
            </div>
            <a href="{{ route('tradinghistory') }}" class="btn btn-info btn-block">View All</a>
        </div>
        
        <div class="col-md-6 py-2">
            <div class="bg-white p-3 p-md-4 rounded border">
                <h4 class="mb-3">Personal Referral Link:</h4>
                <div class="input-group">
                    <input type="text" class="form-control" placeholder="Link" value="{{ Auth::user()->ref_link }}">
                    <div class="input-group-append">
                        <button class="btn btn-warning" onclick="copyFunction('{{ Auth::user()->ref_link }}')">Copy</button>
                    </div>
                </div>
            </div>
            <div class="bg-white mt-3 rounded p-3 border">
                <h3>Referrals</h3>
                <p class="text-black-50">Present our project to your friends, family, or any other community and enjoy the financial benefits. You don't even need an active deposit to receive affiliate commission.</p>
                <a href="{{ route('referuser') }}" class="btn btn-warning">Learn more</a>
            </div>
        </div>
    </div>
    
   
@endsection
