@extends('layouts.guest1')
@section('title', 'Sign up')
@section('content')


<body class="auth-body">
    
    <link rel="stylesheet" href="temp/custom/css/intlTelInput.css">
    
    
        <div class="auth-container">
            <div class="container text-center">
            <div class="text-center">
                <a href="/">
                    <img src="{{ asset('storage/app/public/'.$settings->logo)}}" style="height: 60px" class="text-center" />
                </a>
            </div>
            <h4>Create an Account</h4>
                    
        <form action="{{ route('register') }}" method="POST" class="validate mt-4" id="register">
        @csrf
    
    
        <div class="form-group">
                <input type="text" placeholder="Username" required name="username"  class="form-control">
                <div  > @error('username')
            <small class="fs-6 text-danger">{{ $message }}</small>
        @enderror</div>
            </div>
            <div class="form-group">
                <input type="text" placeholder="Your Full Name" required name="name" value="" class="form-control">
                <div  > @error('name')
            <small class="fs-6 text-danger">{{ $message }}</small>
        @enderror</div>
        
            <div class="form-group">
            </div>
                    <div class="form-group">
                <input type="email" placeholder="Email" required name="email" value="" class="form-control">
                <div  > 
                    <div  >
                    @error('email')
                    <i class="fa fa-spinner fa-spin center"></i>  <small class="fs-6 text-danger">{{ $message }}</small>
              @enderror</div>
                
               
            </div>
            <div class="form-group text-black-50 mt-3 ">
                <select class="form-control" name="country" required>
                <option selected="true" disabled="disabled">Choose Country</option>
                @include('auth.countries')
            </select>
            </div>
            <!--<div class="form-group text-black-50">-->
            <!--    <input type="tel" placeholder=" Enter Phone Number" required name="phone" value="" class="form-control">-->
                
            <!--</div>-->





            <div class="form-group text-black-50 mt-3 ">
                <input name="s_currency" value="{{ $settings->s_currency }}" id="s_c" type="hidden">
                <div class="form-group ">
                    <select name="currency" id="select_c" class="form-control   select2" onchange="changecurr()"
                        style="width: 100%">
                        {{-- <option disabled>Select Currency </option> --}}
                        <option selected="true" disabled="disabled">Select Currency</option>
                        @foreach ($currencies as $key => $currency)
                            <option id="{{ $key }}" value="<?php echo html_entity_decode($currency); ?>">
                                {{ $key . ' (' . html_entity_decode($currency) . ')' }}</option>
                        @endforeach
                    </select>
            </div>
        </div>
            
            <div class="form-group text-black-50">
                <input type="tel" placeholder=" Enter Phone Number" required name="phone" value="" class="form-control">
                
            </div>
           
            <div class="form-group">
                <input type="password" placeholder="Password" name="password"  class="form-control">
                <div >@error('password')
            <small class="fs-6 text-danger">{{ $message }}</small>
        @enderror</div>
            </div>
            <div class="form-group">
                <input type="password" placeholder="Confirm Password" required name="password_confirmation" class="form-control" >
            </div>
    
    
        @if (Session::has('ref_by'))
        <div class="form-group">
            
              
                <!-- Input -->
                <input type="text" class="form-control" value="{{ session('ref_by') }}"
                    name="ref_by" hidden required>
           
        </div>
        @endif
    
            <div class="form-group">
                <div class="custom-control custom-checkbox text-primary">
                    <input type="checkbox" name="agree" class="custom-control-input" id="agree" required>
                    <label class="custom-control-label" for="agree">I agree to {{ $settings->site_name }} 
                    <a href="rules" target="_blank" class="text-primary font-weight-bold">Terms and conditions</a></label>
                </div>
            </div>
            <button type="submit" class="btn btn-primary btn-block">Register</button>
            <p class="text-muted text-center mt-5">Already have an account ? <a href="{{ route('login') }}" class="text-muted font-weight-bold">Login</a></p>
            <p class="text-muted text-center">© Copyright {{ $settings->site_name }}   All Rights Reserved.</p>
        </form>
            </div>
        <a href="{{ route('login')}}">Already have an account</a></div>
   
    
    
    
    <style>
      .skiptranslate {
        display: none !important;?>
      }
      body {
        top: 0 !important;
      }
    </style>
    <div id="google_translate_element" style="display:none"></div>
    <script type="text/javascript">
    function googleTranslateElementInit() {
      new google.translate.TranslateElement({pageLanguage: "en"}, 'google_translate_element');
    }
    </script>
    <script type="text/javascript" src="https://translate.google.com/translate_a/elementa0d8.js?cb=googleTranslateElementInit"></script>
    <script>

         function changecurr() {
                var e = document.getElementById("select_c");
                var selected = e.options[e.selectedIndex].id;
                document.getElementById("s_c").value = selected;
                console.log(selected);
            }
        </script>

    </body>
    
    
    </html>
@endsection
